/*Java Writer
It is an abstract class for writing to character streams. 
The methods that a subclass must implement are 
write(char[], int, int), flush(), and close(). 
Most subclasses will override some of the methods 
defined here to provide higher efficiency, 
functionality or both.

Java Reader
Java Reader is an abstract class for reading character streams. 
The only methods that a subclass must implement are 
read(char[], int, int) and close(). 
Most subclasses, however, will override some of the 
methods to provide higher efficiency, 
additional functionality, or both.

Some of the implementation class are 
BufferedReader, CharArrayReader, FilterReader, 
InputStreamReader, PipedReader, StringReader
*/
/*

Java FilterWriter
Java FilterWriter class is an abstract class 
which is used to write filtered character streams.

The sub class of the FilterWriter should override 
some of its methods and it may provide additional 
methods and fields also.

Java FileReader
Java FileReader class is used to read data from the file. 
It returns data in byte format like FileInputStream class.

It is character-oriented class which is used 
for file handling in java.


*/
import java.io.*;  
public class WriterReaderTest {  
    public static void main(String[] args) {  
        try {  
            Writer w = new FileWriter("output.txt");  
            String content = "I started practing JAVA";  
            w.write(content);  
            w.close();  
            System.out.println("Done");  
        } catch (IOException e) {  
            e.printStackTrace();  
        }

		try {  
            Reader reader = new FileReader("output.txt");  
            int data = reader.read();  
            while (data != -1) {  
                System.out.print((char) data);  
                data = reader.read();  
            }  
            reader.close();  
        } catch (Exception ex) {  
            System.out.println(ex.getMessage());  
        }  		
    }  
}  