/*Constructors
1. Vector(): Creates a default vector of the initial capacity is 10.
Vector<E> v = new Vector<E>();

2. Vector(int size): Creates a vector whose initial capacity 
is specified by size.
Vector<E> v = new Vector<E>(int size);

3. Vector(int size, int incr): Creates a vector whose initial 
capacity is specified by size and increment is specified by incr. 
It specifies the number of elements to allocate each time a 
vector is resized upward.
Vector<E> v = new Vector<E>(int size, int incr);

4. Vector(Collection c): Creates a vector that contains the elements of collection c.
Vector<E> v = new Vector<E>(Collection c);
*/
/*
import java.io.*;
import java.util.*;


class Vector1 {

    
    public static void main(String[] args)
    {
        // Size of the Vector
        int n = 5;

        // Declaring the Vector with
        // initial size n
        Vector<Integer> v = new Vector<Integer>(15);

        // Appending new elements at
        // the end of the vector
        for (int i = 1; i <= n; i++)
            v.add(i);

        // Printing elements
        System.out.println(v);

        // Remove element at index 3
        v.remove(3);

        // Displaying the vector
        // after deletion
        System.out.println(v);

        // iterating over vector elements
        // using for loop
        for (int i = 0; i < v.size(); i++)

            // Printing elements one by one
            System.out.print(v.get(i) + " ");
    }*/
	
	public static void main(String[] arg)
    {

        // Case 1
        // Creating a default vector
        Vector v1 = new Vector();

        // Adding custom elements
        // using add() method
        v1.add(1);
        v1.add(2);
        v1.add("geeks");
        v1.add("forGeeks");
        v1.add(3);

        // Printing the vector elements to the console
        System.out.println("Vector v1 is " + v1);

        // Case 2
        // Creating generic vector
        Vector<Integer> v2 = new Vector<Integer>();

        // Adding custom elements
        // using add() method
        v2.add(1);
        v2.add(2);
        v2.add(3);

        // Printing the vector elements to the console
        System.out.println("Vector v2 is " + v2);
    }*/
	
	public static void main(String args[]) 
    { 
        // Creating an empty Vector 
        Vector<Integer> vec_tor = new Vector<Integer>(); 

        // Use add() method to add elements in the vector 
        vec_tor.add(12); 
        vec_tor.add(23); 
        vec_tor.add(22); 
        vec_tor.add(10); 
        vec_tor.add(20); 

        // Displaying the Vector 
        System.out.println("Vector: " + vec_tor); 

        // Using set() method to replace 12 with 21 
        System.out.println("The Object that is replaced is: "
                        + vec_tor.set(0, 21)); 

        // Using set() method to replace 20 with 50 
        System.out.println("The Object that is replaced is: "
                        + vec_tor.set(4, 50)); 

        // Displaying the modified vector 
        System.out.println("The new Vector is:" + vec_tor); 
    } */
	/*
	public static void main(String[] arg)
    {
        // Create default vector of capacity 10
        Vector v = new Vector();

        // Add elements using add() method
        v.add(1);
        v.add(2);
        v.add("Geeks");
        v.add("forGeeks");
        v.add(4);

        // Removing first occurrence element at 1
        v.remove(1);

        // Checking vector
        System.out.println("after removal: " + v);
    }	
	*/
	
}

/*
Advantages of using Vector in Java
Synchronization: As mentioned before, Vector is synchronized, making it safe to use in a multi-threaded environment.
Dynamic Size: The size of a Vector can grow or shrink dynamically as elements are added or removed, so you don’t have to worry about setting an initial size that will accommodate all elements.
Legacy support: Vector has been part of Java since its inception and is still supported, so it’s a good option if you need to work with older Java code that uses Vector.

Disadvantages of using Vector in Java
Performance: The synchronization in Vector can lead to slower performance compared to other collection classes, such as ArrayList.
Legacy Code: While Vector is still supported, newer Java code is often written using the more modern collection classes, so it may be harder to find examples and support for Vector.
Unnecessary overhead: If you don’t need the synchronization features of Vector, using it will add unnecessary overhead to your code.


*/