
Serialization and Deserialization in Java
Serialization in Java is a mechanism of writing 
the state of an object into a byte-stream. 
It is mainly used in Hibernate, RMI, JPA, EJB and JMS 
technologies.

The reverse operation of serialization is called 
deserialization where byte-stream is converted into an object.
The serialization and deserialization process 
is platform-independent, it means you can serialize 
an object on one platform and deserialize it on a 
different platform.

For serializing the object, we call the 
writeObject() method of ObjectOutputStream class, 
and for deserialization we call the readObject() 
method of ObjectInputStream class.

We must have to implement the Serializable 
interface for serializing the object.

java.io.Serializable interface
Serializable is a marker interface 
(has no data member and method). 
It is used to "mark" Java classes so that 
the objects of these classes may get a certain capability. 
The Cloneable and Remote are also marker interfaces.

The Serializable interface must be 
implemented by the class whose object needs to be persisted.

The String class and all the wrapper classes 
implement the java.io.Serializable interface by default.
*/
import java.io.Serializable;    
class Person implements Serializable{    
 int id;    
 String name;    
 Person(int id, String name) {    
  this.id = id;    
  this.name = name;    
 }    
}    
class Student extends Person{    
 String course;    
 int fee;    
 public Student(int id, String name, String course, int fee) {    
  super(id,name);    
  this.course=course;    
  this.fee=fee;    
 }    
}    
public class SerializeISA  
{    
 public static void main(String args[])  
 {    
    try{    
  //Creating the object    
  Student s1 =new Student(211,"ravi","Engineering",50000);    
  //Creating stream and writing the object    
  FileOutputStream fout=new FileOutputStream("f.txt");    
  ObjectOutputStream out=new ObjectOutputStream(fout);    
  out.writeObject(s1);    
  out.flush();    
  //closing the stream    
  out.close();    
  System.out.println("success");    
  }catch(Exception e){System.out.println(e);}    
  try{    
  //Creating stream to read the object    
  ObjectInputStream in=new ObjectInputStream
  (new FileInputStream("f.txt"));    
  Student s=(Student)in.readObject();    
  //printing the data of the serialized object    
  System.out.println(s.id+" "+s.name+" "+s.course+" "+s.fee);    
  //closing the stream    
  in.close();    
  }catch(Exception e){System.out.println(e);}    
 }    
}  