/*Java Scanner
Scanner class in Java is found in the java.util package. 
Java provides various ways to read input from the keyboard, 
the java.util.Scanner class is one of them.

The Java Scanner class breaks the input into tokens 
using a delimiter which is whitespace by default. 
It provides many methods to read and parse various 
primitive values.

The Java Scanner class is widely used to parse text 
for strings and primitive types using a regular expression. 
It is the simplest way to get input in Java. 
By the help of Scanner in Java, 
we can get input from the user in primitive types such as int, 
long, double, byte, float, short, etc.

The Java Scanner class extends Object class and 
implements Iterator and Closeable interfaces.
*/
import java.util.*;  
public class ScannerClassTest {    
      public static void main(String args[]){                       
          String str = "Hello/This is Java/OOPS.";  
          //Create scanner with the specified String Object  
          Scanner scanner = new Scanner(str);  
          System.out.println("Boolean Result: "+scanner.hasNextBoolean());            
          //Change the delimiter of this scanner  
          scanner.useDelimiter("/");  
          //Printing the tokenized Strings  
          System.out.println("---Tokenizes String---");   
        while(scanner.hasNext()){  
            System.out.println(scanner.next());  
        }  
          //Display the new delimiter  
          System.out.println("Delimiter used: " +scanner.delimiter());            
          scanner.close();  
          }    
}  

