/*Methods: 
• Account(int accountNumber, double balance): Parameterized constructor to initialize attributes. 
• Copy Constructor: Takes another Account object as a parameter 
and initializes a new Account object with the same property values
 as the passed object.
• getAccountNumber(), setAccountNumber(int accountNumber): Getter and setter methods for accountNumber. 
• getBalance(), setBalance(double balance): Getter and setter methods for balance. 
• deposit(double amount): Method to add amount to the balance. 
• withdraw(double amount): Method to subtract amount from the balance (considering validation for sufficient funds). 
• displayAccountDetails(): Method to display account details (bankName, accountNumber and balance).
*/

class Account{
final String bankName="PVPSIT";
private int accountNumber;
private double balance;

Account(){
}

Account(int accountNumber, double balance){
this.accountNumber = accountNumber;
this.balance= balance;
}

Account(Account obj){
this.accountNumber = obj.accountNumber;
this.balance= obj.balance;
}

void setAccountNumber(int accountNumber){
this.accountNumber = accountNumber;
}

int getAccountNumber(){
return accountNumber;
}

void setBalance(double balance){
this.balance=balance;
}

double getBalance(){
return balance;
}

void deposit(double amount){
balance = balance+amount;
}

void withdraw(double amount){
if(balance>=amount)
  balance = balance-amount;
else
  System.out.println("Insufficient balance, cannot withdraw the amount entered");
}

void displayAccountDetails(){
  System.out.println("bankName="+bankName);
  System.out.println("accountNumber="+accountNumber);
  System.out.println("balance=Rs."+balance);
}
}

class SETA{
  static{
  System.out.println("Welcome to PVPSIT");
  }
  
  public static void main(String[] args){
               Account a1 = new Account();
			   a1.setAccountNumber(101);
			   a1.setBalance(1000);
			   a1.displayAccountDetails();
			   
			   Account a2 = new Account(102,3000);
			   //a2.displayAccountDetails();
			   
			   Account a3 = new Account(a2);
			  // a3.displayAccountDetails();
			   
			   a3.withdraw(2000);
			   a3.displayAccountDetails();
			   
			   a2.deposit(3000);
			   a2.displayAccountDetails();
}
  
 } 



