package library.members;

import java.util.ArrayList;
import java.util.List;

public class MemberManager {
    private List<Member> members;

    public MemberManager() {
        members = new ArrayList<>();
    }

    public void addMember(Member member) {
        members.add(member);
    }

    public void removeMember(String memberId) {
        members.removeIf(member -> member.getMemberId().equals(memberId));
    }

    public Member searchMemberById(String memberId) {
        for (Member member : members) {
            if (member.getMemberId().equals(memberId)) {
                return member;
            }
        }
        return null;
    }

    public List<Member> searchMemberByName(String name) {
        List<Member> result = new ArrayList<>();
        for (Member member : members) {
            if (member.getName().equalsIgnoreCase(name)) {
                result.add(member);
            }
        }
        return result;
    }

    public void displayAllMembers() {
        for (Member member : members) {
            System.out.println(member);
        }
    }
}
