package library.main;

import library.books.Book;
import library.books.BookManager;
import library.members.Member;
import library.members.MemberManager;
import library.loans.LoanManager;
import library.reports.ReportGenerator;

public class LibraryManagementSystem {
    public static void main(String[] args) {
        BookManager bookManager = new BookManager();
        MemberManager memberManager = new MemberManager();
        LoanManager loanManager = new LoanManager(bookManager, memberManager);
        ReportGenerator reportGenerator = new ReportGenerator(bookManager, memberManager, loanManager);

        // Add books
        bookManager.addBook(new Book("1234567890", "Java Programming", "John Doe", 2020, true));
        bookManager.addBook(new Book("0987654321", "Python Programming", "Jane Smith", 2021, true));

        // Add members
        memberManager.addMember(new Member("M001", "Alice Brown", "alice@example.com", "1234567890"));
        memberManager.addMember(new Member("M002", "Bob White", "bob@example.com", "0987654321"));

        // Issue and return books
        loanManager.issueBook("L001", "M001", "1234567890", "2024-10-01");
        loanManager.returnBook("L001", "2024-10-15");

        // Generate reports
        reportGenerator.generateBookReport();
        reportGenerator.generateMemberReport();
        reportGenerator.generateActiveLoansReport();
    }
}
