/*
Java BufferedOutputStream class is used for buffering 
an output stream. It internally uses buffer to store data.
 It adds more efficiency than to write data directly
 into a stream. So, it makes the performance fast.

*/
/*
Java BufferedInputStream Class
Java BufferedInputStream class is used to read information 
from stream. It internally uses buffer mechanism to make 
the performance fast.

The important points about BufferedInputStream are:

When the bytes from the stream are skipped or read, 
the internal buffer automatically refilled from the contained 
input stream, many bytes at a time.
When a BufferedInputStream is created, an internal buffer 
array is created.
*/
import java.io.*;  
public class BufferedOutputStreamTest{    
public static void main(String args[])throws Exception{    
     FileOutputStream fout=new FileOutputStream("test.txt");    
     BufferedOutputStream bout=new BufferedOutputStream(fout);    
     String s="Welcome to PVPSIT.";    
     byte b[]=s.getBytes();    
     bout.write(b);    
     bout.flush();    
     bout.close();    
     fout.close();    
     System.out.println("success");    
    

try{    
    FileInputStream fin=new FileInputStream("test.txt");    
    BufferedInputStream bin=new BufferedInputStream(fin);    
    int i;    
    while((i=bin.read())!=-1){    
     System.out.print((char)i);    
    }    
    bin.close();    
    fin.close();    
  }catch(Exception e){System.out.println(e);}    
 }    
}  